/**
 *	@qqbrowser adapter , usefull for calling qqbrowser api
 *	@author sunnyjiang
 *	@version 1.2
 *	@requires utils.js
 */
var browser={};
browser.extension = {};

// true is chrome  , false is qqbrowser 
browser.isSimulate = function(){
	if ('undefined' != typeof(browser.simulateFlag) ){
		return browser.simulateFlag;
	}else{
		if ('undefined' == typeof(qqbrowser)){
			browser.simulateFlag = true; // in chrome
		}else{
			browser.simulateFlag = false; // in qqbrowser 
		}
	}
	return browser.simulateFlag;
};

// pass uuid of dll, load it
browser.extension.dllLoader = function(dllname) {
	var ret={};
	try{
		ret=qqbrowser.extension.dllLoader(dllname);	
	}catch(err) {
		console.log(err.message);
	}
	return ret;
};
// run dll function
browser.extension.execDllFunc = function(dllobj, funcName, callback){
	try{
		// here callback should be a string ,but i think this is not good
		if ("string" != typeof(callback)){
			console.log("callback should be a string ");
			return ;
		}
		if (dllobj){
			dllobj.execDllFunc(funcName, callback);
		}else{
			utils.log("dll is not load");
		}
	}catch(err){
		console.log(err.message);
	}
};

// home get icon , thumb
browser.webthumb={};
browser.webthumb.get = function(url){
	var ret="";
	try{
		ret=qqbrowser.webthumb.get(url);
	}catch(err){
		utils.log("get "+url+" thumb failed");
		ret="";
	}
	return ret;
};

browser.webicon={};
browser.webicon.get = function(url){
	var ret="";
	try{
		ret=qqbrowser.webicon.get(url);
	}catch(err){
		utils.log("get "+url+" icon failed");
	}
	return ret;
};
//data report
browser.dataReport = {
	increase:function(id){
		try {
		     qqbrowser.extension.builtin.statistics.increase(id);
		}catch (err) {
		     console.log(err.message);
		}
	}
};
browser.config = {
	get:function(obj,func){
		qqbrowser.extension.builtin.config.get(obj,func);
	},
	set:function(obj,func){
		qqbrowser.extension.builtin.config.set(obj,func);
	}
};